<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class IsDriver
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle($request, Closure $next)
    {
        // Check if the user is authenticated and not an admin
        if (auth()->check() && auth()->user()->is_driver == 1) {
            return $next($request);
        }

        // Redirect to home with an error message if admin or not authenticated
        return redirect()->route('home')->with('error', "You don't have user access.");
    }
}
