<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/css/style.css')); ?>">

    <!-- Scripts -->
    
</head>

<body>
    <div id="app">
        <section class="admin_dashboard">
            <div class="container">
                <div class="row d-flex justify-content-between align-items-center">
                    <div class="col-md-8">
                        <div class="logo py-2">
                            <a href="<?php echo e(route('admin.home')); ?>"><img src="<?php echo e(asset('/frontend/assets/image/AppLogo.png')); ?>"
                                    alt="logo">
                                <h2>SIGHTSEEING TOURS FOR PEOPLE IN WHEELCHAIRS</h2>
                            </a>
                        </div>
                    </div>
                    <div class="col-md-4 text-end">
                        <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                        <?php echo e(Auth::user()->fname); ?>

                    </a>

                    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                        <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                            onclick="event.preventDefault();
                                   document.getElementById('logout-form').submit();">
                            <?php echo e(__('Logout')); ?>

                        </a>

                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                            <?php echo csrf_field(); ?>
                        </form>
                    </div>
                    </div>
                    
                </div>
                
                <main>
                    <div class="row">
                        <div class="col-md-3 side_bar">
                            <?php echo $__env->make('admin.layout.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-md-9">
                            <?php echo $__env->yieldContent('content'); ?>
                        </div>
                        <div class="bdr"></div>
                    </div>
                    
                       
                </main>
            </div>
        </section>
    </div>


    <footer class="text-white">
        <div class="d-flex justify-content-center py-4">
          <a href="mailto:info@wheelchaircruise.com">info@wheelchaircruise.com</a>
          <a href="tel:647 273 4161">647 273 4161</a>
          <a>155 Sherbourne St. Unit 406, Toronto, Ontario M5A 3W2</a>
        </div>
      </footer>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"
        integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js"
        integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous">
    </script>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\wheelchaircruise\resources\views/admin/layout/app.blade.php ENDPATH**/ ?>