<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Wheelchair Cruise</title>
    <link rel="stylesheet" href="<?php echo e(asset('/frontend/assets/css/custom.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/frontend/assets/css/all.min.css')); ?>">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
</head>

<body>

    <header class="pt-4">
        <div class="container-fluid px-4">
            <div class="row">
                <div class="col-md-6">
                    <div class="logo py-2">

                        <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('/frontend/assets/image/AppLogo.png')); ?>"
                                alt="logo">
                            <h2>SIGHTSEEING TOURS FOR PEOPLE IN WHEELCHAIRS</h2>
                        </a>
                    </div>
                </div>
                <div class="col-md-6 headbtn d-flex justify-content-end align-items-center">
                    <?php if(Auth::check()): ?>
                    <?php endif; ?>
                    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                        <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                            onclick="event.preventDefault();
                                       document.getElementById('logout-form').submit();">
                            <?php echo e(__('Logout')); ?>

                        </a>

                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                            <?php echo csrf_field(); ?>
                        </form>
                    </div>
                </div>
            </div>

        </div>



        <nav class="navbar navbar-expand-lg mx-4">
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
                aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav w-100 justify-content-between px-4 my-2"> <!-- w-100 to make it full width -->
                    <li class="nav-item">
                        <a class="nav-link active" aria-current="page" href="<?php echo e(route('finddriver')); ?>">Find a
                            Driver</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('downloadapp')); ?>">Download App</a>
                    </li>
                    <?php if(Auth::check() && Auth::user()->role = 'is_driver'): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('steps')); ?>">Steps</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('driverportal')); ?>">Driver Portal</a>
                    </li>
                    <?php endif; ?>

                    <?php if(!Auth::check()): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('driverinfo')); ?>">Driver Info</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('signupcustmer')); ?>">Sign Up</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('signin')); ?> ">Sign In</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('driversignin')); ?> ">Driver Sign In</a>
                        </li>
                    <?php else: ?>
                        <li class="nav-item dropdown">
                            <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                <?php echo e(Auth::user()->fname); ?>

                            </a>

                            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                    onclick="event.preventDefault();
                                           document.getElementById('logout-form').submit();">
                                    <?php echo e(__('Logout')); ?>

                                </a>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </div>
                        </li>
                    <?php endif; ?>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('list')); ?>">Waitlist</a>
                    </li>
                </ul>
            </div>
        </nav>
    </header>
<?php /**PATH C:\xampp\htdocs\wheelchaircruise\resources\views/frontend/layout/header.blade.php ENDPATH**/ ?>